using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

using vergila;

namespace emerge01
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	//-////////////////////////////////////////////////////////////////////////////////////
	public class Form1 : System.Windows.Forms.Form
	{
		//
		//	my privates
		//
		FileStream			output;
		FileStream			input;
		VPointLite			pointNow,pointPrev;  //for iterating
		VPointsLite			points;
		VPointsLite			pointsOrg;
		float					c = 8.125f;	//constant that must be tunned

		int						tickSpeed=100;//ms

		State					curState=State.NULL;
		
		Brush				brushRed;

		string											dlgEmergeFileFilter = 
			"Emerge Files| *.emg; | "+
			"Mrg Files( *.EMG)| *.emg";


		private string fileName = 
			"c:\\documents and Settings\\armand vergil\\My Documents\\a11";
		//
		//	desginer privates
		//
		private System.Windows.Forms.Panel panel0;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.PictureBox picbox;
		private System.Windows.Forms.Button b_emerge;
		private System.Windows.Forms.StatusBar sb;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label l_numPoints;
		private System.Windows.Forms.GroupBox gb_tickSpeed;
		private System.Windows.Forms.TrackBar trackbar_tickSpeed;
		private System.Windows.Forms.Timer timer;
		private System.Windows.Forms.Button b_emergeSingle;
		private System.Windows.Forms.Button b_new;
		private System.Windows.Forms.Button b_open;
		private System.Windows.Forms.Button b_saveAs;
		private System.Windows.Forms.StatusBarPanel sb_panelState;
		private System.Windows.Forms.StatusBarPanel sb_panelHint;
		private System.ComponentModel.IContainer components;
	
		public enum State
		{
			NULL,					//when have no points
			EMERGING,			//have points, and they are emerging
			IDLE,						//when have points, but points are stopped
			ITERATING,			//when points are stopped, can iterated
			EMERGE_SINGLE	//emerges one step only
		}

		public State CurState
		{
			get {return curState;}
			set 
			{ 
				curState = value;
				switch( curState)
				{
					case State.NULL:
					{
						//this.mi_joined.Enabled = true; 

						this.b_new.Enabled = false;
						this.b_open.Enabled = true;
						this.b_saveAs.Enabled = false;

						sb.Panels[0].Text = "   State Null";
						sb.Panels[1].Text= "  MouseDown to add a point.   Any enabled button ";
						break;
					}
					case State.EMERGING:
					{
						this.b_new.Enabled = false;
						this.b_open.Enabled = false;
						this.b_saveAs.Enabled = false;

						this.b_emergeSingle.Enabled=false;

						sb.Panels[0].Text = "   State Emerging";
						sb.Panels[1].Text= "  MouseDown to add a point. ";
						break;
					}
					case State.EMERGE_SINGLE:
					{
						EmergeSingle( );
						break;
					}
					case State.ITERATING:
					{
						this.b_emerge.Enabled = false;

						//this.mi_joined.Enabled = false; 

						this.b_new.Enabled = false;
						this.b_open.Enabled = false;
						this.b_saveAs.Enabled = false;

						sb.Panels[0].Text = "   State Iterating";

						break;
					}
					case State.IDLE:
					{
						this.b_emerge.Enabled=true;

						//this.mi_joined.Enabled = false; //original

						this.b_new.Enabled = true;
						this.b_open.Enabled = true;
						this.b_saveAs.Enabled = true;

						this.b_emergeSingle.Enabled=true;

						sb.Panels[0].Text = "   State Idle";
						break;
					}
				}//eos
			}
		}

		public float C
		{
			get { return c;}
			set { c=value;}
		}

		public int TickSpeed
		{
			get { return tickSpeed;}
			set { tickSpeed = value;}
		}
		//-/////////////////////////////////////////////////////////////////////////////////
		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			curState = State.NULL;

			points = new VPointsLite(picbox);

			points.NumPointsChanged+=new PointsLiteEventHandler(
				OnNumPointsChanged);
			
			//
			//	NB-the following statement must be after the previous,
			//	so that msg gets brodcast to interested users.
			//
			points.CurState = VPointsLite.State.CREATING;
			brushRed = new SolidBrush(Color.Red);
			//
			// have to do the following 1 time here at begining, but all other
			// enabling/disabling will be done at OnStateChange
			//
			this.b_new.Enabled = false;
			this.b_open.Enabled = true;
			this.b_saveAs.Enabled = false;

			//this.tb_constantC_Num.Text = c.ToString();
			this.trackbar_tickSpeed.Value = tickSpeed;
			//
			//	NB-during debug, will open file now, and puts points
			//	on screen immediately.
			//string path = @"c:\temp\MyTest.txt";
			FileInfo fi= new FileInfo(fileName);
			if( fi.Exists)
			{
				//
				//	I.G.H-> fileExist, so still must if can open it
				//
				try
				{
					FileStream input = new FileStream
						(
						fileName,
						FileMode.Open, 
						FileAccess.Read
						);
					if( input != null )
					{

						BinaryReader br = new BinaryReader(input);
						points.Read(br);
						input.Close();

						pointsOrg = points;
						points.CurState = VPointsLite.State.CREATING;
						CurState = State.IDLE;

						l_numPoints.Text = points.Count.ToString();
					}

				}
				catch
				{
					// no file, so start in state Null
					CurState=State.NULL;
				}
			}
			else
			{
				CurState=State.NULL;
				this.b_emerge.Enabled=false;
				this.b_emergeSingle.Enabled=false;
			}

			//
			//	end of starting with file already opened
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.sb = new System.Windows.Forms.StatusBar();
			this.sb_panelState = new System.Windows.Forms.StatusBarPanel();
			this.sb_panelHint = new System.Windows.Forms.StatusBarPanel();
			this.panel0 = new System.Windows.Forms.Panel();
			this.panel1 = new System.Windows.Forms.Panel();
			this.picbox = new System.Windows.Forms.PictureBox();
			this.b_emerge = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.l_numPoints = new System.Windows.Forms.Label();
			this.gb_tickSpeed = new System.Windows.Forms.GroupBox();
			this.trackbar_tickSpeed = new System.Windows.Forms.TrackBar();
			this.timer = new System.Windows.Forms.Timer(this.components);
			this.b_emergeSingle = new System.Windows.Forms.Button();
			this.b_new = new System.Windows.Forms.Button();
			this.b_open = new System.Windows.Forms.Button();
			this.b_saveAs = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.sb_panelState)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sb_panelHint)).BeginInit();
			this.panel0.SuspendLayout();
			this.panel1.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.gb_tickSpeed.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.trackbar_tickSpeed)).BeginInit();
			this.SuspendLayout();
			// 
			// sb
			// 
			this.sb.Location = new System.Drawing.Point(0, 624);
			this.sb.Name = "sb";
			this.sb.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																				  this.sb_panelState,
																				  this.sb_panelHint});
			this.sb.ShowPanels = true;
			this.sb.Size = new System.Drawing.Size(912, 32);
			this.sb.SizingGrip = false;
			this.sb.TabIndex = 1;
			this.sb.Text = "statusBar1";
			// 
			// sb_panelState
			// 
			this.sb_panelState.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.sb_panelState.BorderStyle = System.Windows.Forms.StatusBarPanelBorderStyle.None;
			this.sb_panelState.Text = "Null";
			this.sb_panelState.Width = 34;
			// 
			// sb_panelHint
			// 
			this.sb_panelHint.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.sb_panelHint.Width = 10;
			// 
			// panel0
			// 
			this.panel0.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel0.Controls.Add(this.panel1);
			this.panel0.Dock = System.Windows.Forms.DockStyle.Right;
			this.panel0.Location = new System.Drawing.Point(208, 0);
			this.panel0.Name = "panel0";
			this.panel0.Size = new System.Drawing.Size(704, 624);
			this.panel0.TabIndex = 2;
			// 
			// panel1
			// 
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel1.Controls.Add(this.picbox);
			this.panel1.Location = new System.Drawing.Point(8, 8);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(688, 608);
			this.panel1.TabIndex = 0;
			// 
			// picbox
			// 
			this.picbox.BackColor = System.Drawing.SystemColors.Control;
			this.picbox.Location = new System.Drawing.Point(8, 8);
			this.picbox.Name = "picbox";
			this.picbox.Size = new System.Drawing.Size(664, 584);
			this.picbox.TabIndex = 0;
			this.picbox.TabStop = false;
			// 
			// b_emerge
			// 
			this.b_emerge.Location = new System.Drawing.Point(16, 552);
			this.b_emerge.Name = "b_emerge";
			this.b_emerge.Size = new System.Drawing.Size(184, 32);
			this.b_emerge.TabIndex = 3;
			this.b_emerge.Text = "Emerge";
			this.b_emerge.Click += new System.EventHandler(this.b_emerge_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.l_numPoints);
			this.groupBox1.Location = new System.Drawing.Point(8, 24);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(192, 56);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Number of Points";
			// 
			// l_numPoints
			// 
			this.l_numPoints.Location = new System.Drawing.Point(40, 24);
			this.l_numPoints.Name = "l_numPoints";
			this.l_numPoints.Size = new System.Drawing.Size(112, 24);
			this.l_numPoints.TabIndex = 0;
			this.l_numPoints.Text = "0";
			this.l_numPoints.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// gb_tickSpeed
			// 
			this.gb_tickSpeed.Controls.Add(this.trackbar_tickSpeed);
			this.gb_tickSpeed.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.gb_tickSpeed.Location = new System.Drawing.Point(16, 96);
			this.gb_tickSpeed.Name = "gb_tickSpeed";
			this.gb_tickSpeed.Size = new System.Drawing.Size(184, 104);
			this.gb_tickSpeed.TabIndex = 8;
			this.gb_tickSpeed.TabStop = false;
			this.gb_tickSpeed.Text = "Tick Speed";
			// 
			// trackbar_tickSpeed
			// 
			this.trackbar_tickSpeed.Location = new System.Drawing.Point(8, 32);
			this.trackbar_tickSpeed.Maximum = 500;
			this.trackbar_tickSpeed.Minimum = 20;
			this.trackbar_tickSpeed.Name = "trackbar_tickSpeed";
			this.trackbar_tickSpeed.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.trackbar_tickSpeed.Size = new System.Drawing.Size(168, 56);
			this.trackbar_tickSpeed.TabIndex = 0;
			this.trackbar_tickSpeed.TickFrequency = 100;
			this.trackbar_tickSpeed.TickStyle = System.Windows.Forms.TickStyle.Both;
			this.trackbar_tickSpeed.Value = 20;
			this.trackbar_tickSpeed.ValueChanged += new System.EventHandler(this.trackbar_tickSpeed_ValueChanged);
			// 
			// timer
			// 
			this.timer.Tick += new System.EventHandler(this.timer_Tick);
			// 
			// b_emergeSingle
			// 
			this.b_emergeSingle.Location = new System.Drawing.Point(16, 592);
			this.b_emergeSingle.Name = "b_emergeSingle";
			this.b_emergeSingle.Size = new System.Drawing.Size(184, 32);
			this.b_emergeSingle.TabIndex = 9;
			this.b_emergeSingle.Text = "Emerge Single";
			this.b_emergeSingle.Click += new System.EventHandler(this.button1_Click);
			// 
			// b_new
			// 
			this.b_new.Location = new System.Drawing.Point(16, 392);
			this.b_new.Name = "b_new";
			this.b_new.Size = new System.Drawing.Size(184, 32);
			this.b_new.TabIndex = 10;
			this.b_new.Text = "New";
			this.b_new.Click += new System.EventHandler(this.button1_Click_1);
			// 
			// b_open
			// 
			this.b_open.Location = new System.Drawing.Point(16, 432);
			this.b_open.Name = "b_open";
			this.b_open.Size = new System.Drawing.Size(184, 32);
			this.b_open.TabIndex = 11;
			this.b_open.Text = "Open";
			this.b_open.Click += new System.EventHandler(this.button2_Click);
			// 
			// b_saveAs
			// 
			this.b_saveAs.Location = new System.Drawing.Point(16, 472);
			this.b_saveAs.Name = "b_saveAs";
			this.b_saveAs.Size = new System.Drawing.Size(184, 32);
			this.b_saveAs.TabIndex = 12;
			this.b_saveAs.Text = "Save As";
			this.b_saveAs.Click += new System.EventHandler(this.button3_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(7, 17);
			this.ClientSize = new System.Drawing.Size(912, 656);
			this.Controls.Add(this.b_saveAs);
			this.Controls.Add(this.b_open);
			this.Controls.Add(this.b_new);
			this.Controls.Add(this.b_emergeSingle);
			this.Controls.Add(this.gb_tickSpeed);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.b_emerge);
			this.Controls.Add(this.panel0);
			this.Controls.Add(this.sb);
			this.Font = new System.Drawing.Font("Microsoft Sans Serif", 11.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "TestFixture( Emerge )";
			((System.ComponentModel.ISupportInitialize)(this.sb_panelState)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sb_panelHint)).EndInit();
			this.panel0.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.gb_tickSpeed.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.trackbar_tickSpeed)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void EmergeSingle()
		{
			this.PointsEmerge(points);
			picbox.Invalidate();
			
		}
		private void PointsEmerge( VPointsLite pts )
		{
			//
			int numPts = pts.Count;
			int i;
			//
			//	will store the deltas for each point in <points>
			//
			VPointLite[] vplArr = new VPointLite[pts.Count];

			//
			//	use 2 variables nborLeftIdx, nborRightIdx
			//	to trace the the 2 immediate neighbors 
			//
			int nborPrevIdx = numPts-1;
			int meIdx = 0;
			int nborPostIdx = 1;
			bool bCnt = true;
			while( bCnt )
			{
				VPointLite vp = new VPointLite();;

				for( i=0; i<numPts; i++)
				{
					if( i == meIdx )
					{
						// do noting
					}
					else if( i == nborPrevIdx || i == nborPostIdx)
					{
						//attractor
						int xx=10;
						double d=pts[i].DistanceTo
							(
							pts[meIdx].X,pts[meIdx].Y
							);
						//
						//	NB-the only difference in computing the
						//	attraction or repulsion is the change in 
						//	position of two input pointsin SubtractPoints()
						//
						VPointLite w=VPointLite.SubtractPoints
							(
							pts[meIdx].X, pts[meIdx].Y, pts[i].X, pts[i].Y

							);
						w.TimesEquals((float)( C/d ) );

						vp.PlusEquals( w.X, w.Y );
					}
					else
					{
						//repulsor
						double d=points[i].DistanceTo
							(
							pts[meIdx].X,pts[meIdx].Y
							);
						
						VPointLite w=VPointLite.SubtractPoints
							(
							pts[i].X, pts[i].Y ,pts[meIdx].X, pts[meIdx].Y
							);
						w.TimesEquals((float)( C/d ) );

						vp.PlusEquals( w.X, w.Y );
					}
				}
				vplArr[meIdx] = vp;
				meIdx++;
				nborPrevIdx+=1;
				nborPrevIdx %= numPts;
				nborPostIdx++;
				nborPrevIdx %= numPts;
				//bCnt = false;
				if( meIdx == pts.Count )
				{
					//
					//	can now modify points
					//
					for( i=0; i< pts.Count; i++)
					{
						pts[i].PlusEquals(vplArr[i].X, vplArr[i].Y);
					}
					bCnt = false;
				}
			}
		}

		private void b_emerge_Click(object sender, System.EventArgs e)
		{
			//BUTTON: EMERGE
			//	NB-Thoughout all of this, 'points' state is State.IDLE
			//	since points does NOT know about 'emerging' or
			//	'iterating'
			
			if( CurState != State.EMERGING )
			{
				b_emerge.Text = "Pause";
				CurState = State.EMERGING;

				timer.Start();
			}
			else
			{
				timer.Stop();
				b_emerge.Text = "Emerge";
				CurState = State.IDLE;
			}
		}
		private void button1_Click(object sender, System.EventArgs e)
		{
			//
			//	EMERGE_SINGLE
			//
			// Needed to see what was happening at begining when forces
			//	are strongest, so gave user ability to single step
			//	throught iteration
			//
			CurState = State.EMERGE_SINGLE;		
		}

		private void timer_Tick(object sender, System.EventArgs e)
		{
			switch( curState )
			{
				case State.ITERATING:
				{
					/*
					if( etor==points.Count )
					{
						timer.Stop();
						IterationStopped();
						return;
					}
					pointPrev.Draw( graphicsIter);
					pointPrev = pointNow;

					pointNow = points[etor++];
					pointNow.Draw( graphicsIter ,brushRed);
					*/

					break;
				}
				
				case State.EMERGING:
				{
					PointsEmerge( points );
					PointsEmerge( points );

					picbox.Invalidate();
					break;
			
				}

			}//eos		
		}

		void OnNumPointsChanged(object sender, PointsLiteEventArgs e)
		{
			int xx=10;
			this.l_numPoints.Text=e.newNumPoints.ToString();
			if( e.newNumPoints == 4)
			{
				CurState=State.IDLE;
			}
		}
		private void trackbar_tickSpeed_ValueChanged(object sender, System.EventArgs e)
		{
			//TICKSPEED CHANGED
			timer.Interval=this.trackbar_tickSpeed.Value;		
		}



		private void button1_Click_1(object sender, System.EventArgs e)
		{
			//BUTTON: NEW
			points.Clear();
			if( pointsOrg != null )
			{
				pointsOrg.Clear();
			}
			l_numPoints.Text = "0";
			picbox.Invalidate();
			points.CurState = VPointsLite.State.CREATING;
			this.CurState=State.NULL;
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			//BUTTON: OPEN
			OpenFileDialog openDlg = new OpenFileDialog();
			openDlg.Filter=this.dlgEmergeFileFilter;
			if( openDlg.ShowDialog() != DialogResult.OK)
				return;

			string fileName = openDlg.FileName;
			input = new FileStream
				(
				fileName,
				FileMode.Open, 
				FileAccess.Read
				);

			BinaryReader br = new BinaryReader(input);
			
			points.Read(br);
			input.Close();
			
			points.CurState = VPointsLite.State.CREATING;
			pointsOrg = points;
			CurState = State.IDLE;

			l_numPoints.Text = points.Count.ToString();

			picbox.Invalidate();
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			//BUTTON: SAVE_AS
			//SAVE_AS
			SaveFileDialog saveDlg = new SaveFileDialog();
			saveDlg.Filter=this.dlgEmergeFileFilter;
			DialogResult dsr = saveDlg.ShowDialog();
			//string fileName;
			saveDlg.CheckFileExists = false;

			if(dsr == DialogResult.Cancel)
				return; 
			string fileName = saveDlg.FileName;

			output = new FileStream
				( 
				fileName, 
				FileMode.OpenOrCreate,
				FileAccess.Write
				);

			BinaryWriter bw = new BinaryWriter( output);
			bw.Seek(0,SeekOrigin.Begin);

			points.Write(bw);
			
			output.Close();	
		}

		private void b_restore_Click(object sender, System.EventArgs e)
		{
			//BUTTON: RESTORE
			//
			//	restores the original points of this configuration.
			//
			points=pointsOrg;
			picbox.Invalidate();
		}

		private void button1_Click_2(object sender, System.EventArgs e)
		{
			//BUTTON: THE RULE:
		}
	}
}
