using System;
using System.Drawing;
using System.Windows.Forms;
using System.IO;		//for BinaryReader/Writer

namespace vergila
{
	/// <summary>
	/// This object is needed cause VPoint object is NOT  lite.
	/// Objective is to create the minimum properties for a point
	/// 
	/// Oct3/02: just found the following to be true
	/// Can not add a Point to a Point
	/// Can add a Point to a Size,
	/// can add a Size to a Size
	/// 
	/// WHat gives?
	/// It may be better to do this VPointLite object with
	/// a SizeF instead of the current PointF base that i 
	/// am using. 
	/// 
	/// Will finish this one, and then do a SPointLite object
	/// with SizeF as base, and compare the two. Will also speak to 
	/// Driss about this.
	/// 
	/// Nov1/02: making a temporary decision on 
	/// a) Owner Dependent objects.		
	///		use ctors's VPointLite() or VPointLite( float x, float y) only
	///		owner then has reponsiblity for painting( uses Draw(Graphics g)
	///		and mouseEvent ( owner intercepts the mouse and paint msgs
	/// b) Owner Independent objects.
	///		Use ctors VPointLite(panel/form), 
	///		VPointLite(Panel/form,float x,float y).
	///		Owner can forget about paint or mouse events. VPointLite will 
	///		handle.
	///	
	/// </summary>
	//-////////////////////////////////////////////////////////////////////////////////////
	//-////////////////////////////////////////////////////////////////////////////////////
	[Serializable]
	public class VPointLite
	{
		private Control		display = null;

		private PointF			p;
		private float			delta=3;
		private Color			color;
		private Brush			brush;
		private State			curState = State.NULL;
		private const int		hitDelta=4;

		private PointF  offset;

		public enum State
		{
			NULL,
			IDLE,
			CREATING,
			MOVING
		}

		public State CurState
		{
			get{ return curState;}
			set{ curState = value;}
		}

		public Color Color
		{
			get{ return color; }
			set
			{
				if( color == value)
				{
					return;
				}
				color=value;
				brush.Dispose();
				brush = new SolidBrush(color);

			}
		}

		public float X
		{
			get { return p.X;}
			set { p.X = value;}
		}

		public float Y
		{
			get { return p.Y;}
			set { p.Y = value;}
		}

		public int iX
		{
			get { return (int)Math.Round(p.X);}
		}

		public int iY
		{
			get { return (int)Math.Round(p.Y);}
		}
		
		public  Point Point
		{
			get 
			{
				return new Point
					(
					(int)Math.Round(p.X),
					(int)Math.Round(p.Y)
					);
			}
			//don't think need a set: will see!
		}

		public PointF PointF
		{
			get {return p;}
			set { p = value;}
		}
		//-////////////////////////////////////////////////////////////////////
		//
		//	dependant VPointLite
		//
		/// <summary>
		/// using this ctor implies that owner handles all mouse/paint events
		/// </summary>
		public VPointLite( )
		{
			p.X = 0f;
			p.Y = 0f;
			Init();
		}
		/// <summary>
		/// using this ctor implies that owner handles all mouse/paint events
		/// </summary>
		public VPointLite( float x, float y)
		{
			p.X = x;
			p.Y = y;
			Init();
			CurState = State.IDLE; //ready to be drawn
		}
		//
		//	Independent VPointLite
		//
		/// <summary>
		/// using this ctor implies that owner NOT handle mouse/paint events,
		/// cause object is independent
		/// </summary>
		/// <param name="form"></param>
		public VPointLite(Control display)
		{
			//this.form = form;
			this.display = display;
			p.X = 0f;
			p.Y = 0f;
			Init();
			
			Subscribe_Paint(display);
			Subscribe_MouseDown(display);
		}
		/// <summary>
		/// using this ctor implies that owner NOT handle mouse/paint events,
		/// cause object is independent
		/// </summary>
		/// <param name="form"></param>
		public VPointLite( Control display, float x, float y)
		{
			this.display = display;
			p.X=x;
			p.Y=y;
			Init();
			CurState = State.IDLE;

			Subscribe_Paint(display);
			Subscribe_MouseDown(display);
		}
		//-////////////////////////////////////////////////////////////////////
		//
		//	subscribing/unsubscribing:
		//	Note that for this object, since it has no form or panel,
		//	subscribing must be done from outside the object
		//
		public void Subscribe_MouseDown(Control display)
		{
			display.MouseDown += new MouseEventHandler( OnMouseDown );
		}

		public void UnSubscribe_MouseDown(Control display)
		{
			display.MouseDown -= new MouseEventHandler( OnMouseDown );
		}

		public void Subscribe_MouseMove(Control display)
		{
			display.MouseMove += new MouseEventHandler( OnMouseMove );
		}

		public void UnSubscribe_MouseMove(Control display)
		{
			display.MouseMove -= new MouseEventHandler( OnMouseMove );
		}

		public void Subscribe_MouseUp(Control display)
		{
			display.MouseUp += new MouseEventHandler( OnMouseUp );
		}

		public void UnSubscribe_MouseUp(Control display)
		{
			display.MouseUp -= new MouseEventHandler( OnMouseUp );
		}
		
		public void Subscribe_Paint(Control display)
		{
			display.Paint += new PaintEventHandler( OnPaint );
		}

		public void UnSubscribe_Paint(Control display)
		{
			display.Paint -= new PaintEventHandler( OnPaint );
		}
		//
		//	drawing 
		//
		public void Draw( Graphics g)
		{
			g.FillEllipse(brush, p.X-delta, p.Y-delta, 2*delta, 2*delta);
		}

		public void Draw( Graphics g, Brush sBrush)
		{
			g.FillEllipse(sBrush, p.X-delta, p.Y-delta, 2*delta, 2*delta);
		}
		//
		//	pseudo operators
		//
		public VPointLite PlusEquals( float x, float y)
		{
			p.X+=x;
			p.Y+=y;
			return this;
		}
		public VPointLite MinusEquals( float x, float y)
		{
			p.X-=x;
			p.Y-=y;
			return this;
		}

		public VPointLite TimesEquals( float scaler)
		{
			p.X*=scaler;
			p.Y*=scaler;
			return this;
		}
		
		public VPointLite Plus( float x, float y)
		{
			return new VPointLite( p.X+x, p.Y+y);
		}

		public VPointLite Minus( float x, float y)
		{
			return new VPointLite( p.X-x, p.Y-y);
		}
		
		//
		//	miscellaneous
		//
		public bool Contains( float x, float y)
		{
			double d = (x-p.X)*(x-p.X)+(y-p.Y)*(y-p.Y);//better still
			if( d < 4*4 ) //using 4 squared, to save doing sqrt()
			{
				return true;
			}
			return false;
		}
		public float DistanceTo( float x, float y)
		{
			return (float)Math.Sqrt
			(
				(x-p.X)*(x-p.X) + (y-p.Y)*(y-p.Y)
			);
		}

		public float DistanceSquaredTo( float x,float y)
		{
			return (x*x +y*y);
		}

		public float Norm()
		{
			return DistanceTo( 0f,0f);
		}
		
		public void NormTo( float newLength )
		{
            TimesEquals( newLength / Norm() );
		}
		//
		//	like Friends in cpp
		//
		/// <summary>
		/// Used to add any 2 points of { Point, PointF, VPointLite }
		/// </summary>
		/// <param name="p1"></param>
		/// <param name="p2"></param>
		/// <returns></returns>
		public static VPointLite AddPoints(float x1, float y1, float x2, float y2 )
		{
			VPointLite p = new VPointLite();
			
			p.X = x1+x2;
			p.Y = y1+y1;
			return p;
		}
		/// <summary>
		/// Use to subtract and VPointLites
		/// </summary>
		/// <param name="p1"></param>
		/// <param name="p2"></param>
		/// <returns></returns>
		public static VPointLite SubtractPoints(float x1, float y1, float x2, float y2 )
		{
			VPointLite p = new VPointLite();
			
			p.X = x1-x2;
			p.Y = y1-y2;
			return p;

		}
		//
		//	IO stuff
		//
		public void Write(BinaryWriter bw)
		{
			bw.Write(p.X);
			bw.Write(p.Y);
		}
		
		public void Read(BinaryReader br)
		{
			p.X = (float)br.ReadSingle();
			p.Y = (float)br.ReadSingle();
		}
		//
		//	private methods
		//
		private void Init()
		{
			color = Color.Black;
			brush = new SolidBrush(color);
			CurState = State.NULL;
		}
		void MoveTo( float x, float y)
		{
			p.X=x;
			p.Y=y;
		}
		//
		//	Event handlers
		//
		private void OnMouseDown( object sender, MouseEventArgs e)
		{
			if( DistanceTo(e.X,e.Y ) < hitDelta )
			{
				//have a hit
				offset.X = p.X-e.X;
				offset.Y = p.Y-e.Y;

				Subscribe_MouseMove(display);
				Subscribe_MouseUp(display);
				CurState = State.MOVING;
			}
 
		}
		private void OnMouseMove( object sender, MouseEventArgs e)
		{
			switch( curState )
			{
				case State.MOVING:
				{
					MoveTo(e.X+offset.X,e.Y+offset.Y);
					display.Invalidate();

					break;
				}
			}
		}
		private void OnMouseUp( object sender, MouseEventArgs e)
		{
			switch( curState )
			{
				case State.MOVING:
				{
					UnSubscribe_MouseMove(display);
					UnSubscribe_MouseUp(display);
					CurState = State.NULL;
					break;
				}
			}
		
		}
		private void OnPaint( object sender, PaintEventArgs e)
		{
			if( curState != State.NULL )
			{
				Region rgnClipPrev = e.Graphics.Clip;
				e.Graphics.Clip = new Region( GetClipRectangle());
				Draw(e.Graphics);
				e.Graphics.Clip = rgnClipPrev;
			}
		}
		
		private RectangleF  GetClipRectangle()
		{
			return new RectangleF(p.X-delta,p.Y-delta, 2*delta, 2*delta);
		}
	}

}
