using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;
using System.IO;		//for BinaryReader/Writer 


namespace vergila
{
	/// <summary>
	/// a collection class for the VPointLite object. Have also
	/// decided to broadcast the StateChange event to all interested 
	/// parties, basically in case they want to report the state.
	/// 
	/// QUESTION NOT RESOLVED:
	///		Could have the VPointsObject itsef call the openFile or
	///		saveFile dialogs, and remove the burden from programer
	///		user, but should i, and can i have it that both options
	///		are available, and decision is left to the programer user
	///	Oct18/02:
	///		Added ability to join points with a line.
	///		will request a pen to do the drawing with the line
	///		so color is user's concern
	///		
	/// </summary>
	//-/////////////////////////////////////////////////////////////////////////////////////
	public class PointsLiteEventArgs : EventArgs
	{
		public string newStateString;
		public int newNumPoints;

		public PointsLiteEventArgs(){}
		public PointsLiteEventArgs(string newStateString)
		{
			this.newStateString=newStateString;
		}
		public PointsLiteEventArgs( int newNumPoints)
		{
			this.newNumPoints=newNumPoints;
		}	
	}
	//-/////////////////////////////////////////////////////////////////////////////////////
	public delegate void PointsLiteEventHandler(
	object sender, PointsLiteEventArgs e);
	//-/////////////////////////////////////////////////////////////////////////////////////
	public class VPointsLite : IEnumerable
	{
		//
		//	privates
		//
		ArrayList							list;
		Control							display = null;
		
		bool								bJOINED=false;
		
		VPointLite						point;

		float								offsetX;
		float								offsetY;
		int									th=0;
		Pen								penJoin;
		State								curState;

		PointsLiteEventHandler		stateChangedHandlers=null;
		PointsLiteEventHandler		numPointsChangedHandlers=null;
		//
		//	enums
		//
		public enum State
		{
			NULL,
			IDLE,
			CREATING,
			MOVING
		}
		//
		//	event properties
		//
		public event PointsLiteEventHandler StateChanged
		{
			add{ this.stateChangedHandlers+=
					 new PointsLiteEventHandler(value);}
			remove{ this.stateChangedHandlers-=value;}
		}
		public event PointsLiteEventHandler NumPointsChanged
		{
			add{ 
				this.numPointsChangedHandlers+=
					new PointsLiteEventHandler( value);}
			remove{ this.numPointsChangedHandlers-=value;}
		}
		//
		//	properties
		//
		public State CurState
		{
			get{ return curState;}
			set
			{ 
				curState = value;
				if( stateChangedHandlers != null)
				{
					stateChangedHandlers(
						this, new PointsLiteEventArgs(curState.ToString()) );
				}
			}
		}
		public Graphics Graphics
		{
			get
			{
				if( display != null )
				{
					return display.CreateGraphics();
				}
				return null;
			}
		}
		public bool	boolJOINED
		{
			get { return bJOINED; }
			set { bJOINED = value;}
		}
		public new int Count
		{
			get { return list.Count; }
		}
		public VPointLite this[int idx]		//VPointLite indexer
		{
			get
			{ 
				if( idx > -1 && idx < list.Count)
				{
					return(VPointLite) list[idx];
				}
				else
				{
					MessageBox.Show
						( 
						"Index out of bounds",
						"VPointsLite",
						MessageBoxButtons.OK,
						MessageBoxIcon.Asterisk
						);
					return new VPointLite(-999,-999);
				}
			}
			set
			{
				if( idx > -1 && idx < list.Count)
				{
					list[idx]=value;
				}
				else if( idx == list.Count )
				{
					list.Add(value);
				}
			}
		}
		//-////////////////////////////////////////////////////////////////////

		public VPointsLite(Control display)
		{
			this.display = display;
			this.display.MouseDown+= new MouseEventHandler( OnMouseDown );
			this.display.Paint +=  new PaintEventHandler( OnPaint );

			Init();
		}
		public VPointsLite( VPointsLite pts)
		{
			if( pts.display != null )
			{
				display= pts.display;
				pts = new VPointsLite( display);

				display.MouseDown += new MouseEventHandler( OnMouseDown );
				display.MouseMove += new MouseEventHandler( OnMouseMove );
				display.MouseUp += new MouseEventHandler( OnMouseUp );

				display.Paint +=  new PaintEventHandler( OnPaint );
			}

			VPointLite pl;
			foreach( VPointLite p in list)
			{
				//
				//	must create a new object or will have a shallow copy
				//
				pl=new VPointLite(p.X,p.Y);
				list.Add(pl);
			}
		}
		//
		//	to allow use of foreach()
		//
		public IEnumerator GetEnumerator() 
		{
			return list.GetEnumerator();
		}
		//
		//	Declare the enumerator class:
		//
		public class PointEnumerator 
		{
			int nIndex;
			VPointsLite  points;
			public PointEnumerator(VPointsLite points) 
			{
				this.points = points;
				nIndex = -1;
			}
			public bool MoveNext() 
			{
				nIndex++;
				return(nIndex < points.Count );
			}
			public VPointLite Current 
			{
				get 
				{
					return( points[nIndex] );
				}
			}	
		}//eoc PointEnumerator
		public void View()
		{
			//
			//	this method should be used only during debbuging
			//	It allows programer to see contents of list
			//
			foreach( VPointLite vp in list )
			{
				int xx=10;						//view vp.p from here in watch window
			}
		}
		public void Add( VPointLite p)
		{
			list.Add( p );
		}
		public void Clear()
		{
			list.Clear();
			CurState = State.NULL;
		}
		public void SetColor( int idx, Color color)
		{
			this[idx].Color=color;
		}
		public void Write(BinaryWriter bw)
		{
			bw.Write(list.Count);
			foreach( VPointLite vp in list)
			{
				vp.Write(bw);
			}
		}
		public void Read(BinaryReader br)
		{
			list.Clear();

			int count= br.ReadInt32();
			for( int i=0; i<count; i++)
			{
				VPointLite vp = new VPointLite();
				vp.Read(br);
				list.Add(vp);
			}
			//
			//	once points are ready to be displayed on screen,
			//	state is IDLE
			//
			CurState = State.IDLE;
		}

		public void Paint( PaintEventArgs e)
		{
			foreach( VPointLite vp in list)
			{
				vp.Draw(e.Graphics);
			}
		}
		//
		//	private methods
		//
		private void Init()
		{
			list = new ArrayList();
			CurState = State.NULL;
			penJoin = new Pen(Color.Blue,1);
		}
		private void OnMouseDown( object sender, MouseEventArgs e )
		{
			switch( CurState )
			{
				case State.CREATING:
				{
					VPointLite p = new VPointLite(e.X,e.Y);
					Add( p );
					if( display != null )
					{
						display.Invalidate();
					}
					if(this.numPointsChangedHandlers!=null)
						this.numPointsChangedHandlers(
							this,new PointsLiteEventArgs( list.Count ));
					break;
				}
		 		case State.IDLE:
				{
					int idx = Contains( e.X, e.Y );
					if( idx < 0 )
					{
						return;
					}
					point = this[idx];
					offsetX = e.X-point.X;
					offsetY = e.Y-point.Y;

					display.MouseMove+= new MouseEventHandler(OnMouseMove);
					display.MouseUp+= new MouseEventHandler(OnMouseUp);
					

					CurState = State.MOVING;
					
					break;
				}
			}
		}
		private void OnMouseMove( object sender, MouseEventArgs e )
		{

			switch( CurState )
			{
				case State.MOVING:
				{
					point.X = e.X-offsetX;
					point.Y = e.Y-offsetY;
					//
					//	great saving in time here if i supply the
					//	clip rect which in this case would be the 
					//	rectangle that  contains both the rectangle of
					//	where the point was, and the rectangle of where
					//	point will be. MUST DO SOON
					//
					display.Invalidate();
					break;
				}
			}//eos
		}
		private void OnMouseUp( object sender, MouseEventArgs e )
		{
			switch( CurState )
			{
				case State.MOVING:
				{
					CurState = State.IDLE;
					display.MouseMove+= new MouseEventHandler(OnMouseMove);

					display.MouseUp+= new MouseEventHandler(OnMouseUp);
					break;
				}
			}//eos
		}
		private int Contains( int x, int y)
		{
			for( int i=0; i<list.Count; i++)
			{
				if( this[i].Contains( x,y ) )
				{
					return i;
				}
			}
			return -1;
		}
		public void Paint(Graphics g)
		{
			if( bJOINED )
			{
				int c= list.Count;

				for( int i=0; i<c-1; i++)
				{
					(this[i]).Draw(g);
					g.DrawLine(penJoin, this[i].Point,this[i+1].Point );
				}
				(this[c-1]).Draw(g);
			}
			else
			{
				for( int i=0; i<list.Count; i++)
				{
					(this[i]).Draw(g);
				}
			}
		}
		private void OnPaint(object sender, PaintEventArgs e)
		{
			Paint(e.Graphics);
		}
	}
}
