/*
 *  OSUtil2.cpp
 *  aij03 AI Junkie Emergence Contest
 *
 *  Created by David Lotts on Tue Oct 14 2003.
 *  This is used for cross-platiform code only.
 *
 */
      // this whole thing is only useful on the Mac.
#if  defined(mac_os_x)

#include "OSUtil.h"

// Find a resource file, how it's done on a Mac
// urlOut must be at least 255 chars.
char *getResourceFile(const char *filename , const char *ext,  UInt8 *urlOut) //
{
    CFBundleRef mainBundle;
    // Get the main bundle for the app
    mainBundle = CFBundleGetMainBundle();
    fprintf( stderr,  "getResourceFile(): got bundle ref.\n");    fflush(0);	
	
    CFURLRef    url;
    CFStringRef cfsFilename = CFStringCreateWithCString (NULL, filename, kCFStringEncodingMacRoman);
    CFStringRef cfsExt      = CFStringCreateWithCString (NULL, ext     , kCFStringEncodingMacRoman);
    fprintf( stderr,  "getResourceFile(): created strings.\n");    fflush(0);	
    // Look for a resource in the main bundle by name and type.
    url = CFBundleCopyResourceURL( mainBundle, 
                    cfsFilename, 
                    cfsExt, 
                    NULL /* dir in bundle to start looking */);
    //strlcpy(url,urlOut,255)
    if (url == NULL)
    { 
        fprintf( stderr,  "getResourceFile(): copy URL failed finding file.\n");    fflush(0); 
        exit(0);
    }
    else
        { fprintf( stderr,  "getResourceFile(): copy URL worked.\n");    fflush(0); }
    
    if ( ! CFURLGetFileSystemRepresentation(url, true, urlOut, 255))
    {
        fprintf(stderr, "getResourceFile() failed string conversion of filename URL."); fflush(0);	
        exit(1);
    }
    fprintf( stderr,  "getResourceFile(): getfsr ran.\n");    fflush(0);	

    if (url) 
        CFRelease(url);	
    CFRelease(cfsFilename);
    CFRelease(cfsExt);
    fprintf( stderr,  "getResourceFile(): done.\n");    fflush(0);	

    return urlOut;

}
#endif
