/*
 *  WindowUtil.h
 *  Multi OS window utilities, like MessageBox
 */


#ifdef mac_os_x
    // this is for the Mac api to find image files.
    #include <CoreServices/CoreServices.h>   // needed for resource functions.
#endif    
#if  defined(mac_os_x) || defined(linux)
    // mac and others need a messagebox.
    // TODO: need a message box system call...
    #define MB_OK                   1
    #define MB_ICONEXCLAMATION      2
    #define MB_ICONWARNING          4
    #define MB_ICONSTOP             8
    #define MB_APPLMODAL            16
    #define MessageBox( a, msg, c, d )  fprintf(stderr, msg);
#endif

#if  defined(mac_os_x)
    // Mac's lib has only pow()
    inline float powf(float x, float y)
    {
        return pow(x,y);
    }

    inline float sqrtf(float x)
    {
        return sqrt(x);
    }
    // get a file from the app bundle.
    char *getResourceFile(const char *filename , const char *ext, UInt8 *urlOut);

#else  // else not Mac
    // this only works for string literals as parameters:
    #define getResourceFile(filename, ext, urlOut)  \
        ( sprintf(urlOut, "Data\\%s.%s", filename, ext ), urlOut )
#endif

